unit ResumeFormUnit;
{
    UNIT ResuneFormUnit;
    Version number 1.0.

This unit contains YAFTP Resume Transfer Request form and it's handling
routines.
Created by Pter Karsai }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TTransResForm = class(TForm)
    Image1: TImage; Image2: TImage; Image3: TImage;
    GroupBox1: TGroupBox;
    Label1: TLabel; Label2 : TLabel;  Label3: TLabel; Label4: TLabel;
    Label5: TLabel; Label6 : TLabel;  Label7: TLabel; Label8: TLabel;
    Label9: TLabel; Label10: TLabel; Label11: TLabel; Label12: TLabel;
    AddToSchedulerB : TButton; TransferB       : TButton;
    ResumeB         : TButton; CancelB         : TButton;
    RemoteFileL     : TLabel;  RemoteFileSizeL : TLabel;
    RemoteFileDateL : TLabel;  LocalFileL      : TLabel;
    LocalFileSizeL  : TLabel;  LocalFileDateL  : TLabel;

    procedure TransferBClick(Sender: TObject);
    procedure ResumeBClick(Sender: TObject);
    procedure AddToSchedulerBClick(Sender: TObject);
    procedure CancelBClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
   ClickedButton : byte;  { value of pressed button }

{ ----------------------------------------------------------------------------}
{ public methods, event handlers }
{ ----------------------------------------------------------------------------}
   procedure ShowLocalFile(FileName, FileSize, FileDate: string);
{ Function: Shows local file data. }

   procedure ShowRemoteFile(IsDown: boolean; FileName, FileSize,
                            FileDate: string);
{ Function: Shows remote file data. If IsDown is TRUE, TransferB's caption
  will be 'Download', else 'Upload'. }

   function RunDialog: byte;
{ Function: show TransResForm and return with the button pressed. }

end;

{------------------------------------------------------------------------------}

var
  TransResForm: TTransResForm;

implementation
{$R *.DFM}
uses FTPFormUnit;

{------------------------------------------------------------------------------}

procedure TTransResForm.ShowLocalFile(FileName, FileSize, FileDate: string);
begin
{ show all available data }
    LocalFileL.Caption     := FileName;
    LocalFileSizeL.Caption := FileSize;
    LocalFileDateL.Caption := FileDate;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.ShowRemoteFile(IsDown: boolean; FileName, FileSize,
                                       FileDate: string);
begin
{ show all available data }
    RemoteFileL.Caption     := FileName;
    RemoteFileSizeL.Caption := FileSize;
    RemoteFileDateL.Caption := FileDate;

{ set TransferB's caption }
    if IsDown then
       TransferB.Caption:= '&Download'
    else
       TransferB.Caption:= '&Upload'
end;

{------------------------------------------------------------------------------}

function TTransResForm.RunDialog: byte;
begin
{ startup: no button pressed }
    ClickedButton:= drNoButton;
{ show form and disable main FTP window }
    TransResForm.Show;
    FTPForm.Enabled:= false;
{ we're waiting 'till user press a button or close form }
    while ClickedButton = drNoButton do begin
          Application.ProcessMessages;
          if Application.Terminated then exit;
    end;
{ just return with clicked button constant }
    FTPForm.Enabled:= true;  { we want to click more and more :) }
    Result:= ClickedButton;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.TransferBClick(Sender: TObject);
begin
    ClickedButton:= drTransfer;
    TransResForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.ResumeBClick(Sender: TObject);
begin
    ClickedButton:= drResume;
    TransResForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.AddToSchedulerBClick(Sender: TObject);
begin
    ClickedButton:= drAddToScheduler;
    TransResForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.CancelBClick(Sender: TObject);
begin
    ClickedButton:= drCancel;
    TransResForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransResForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    if ClickedButton = drNoButton then ClickedButton:= drCancel;
end;

{------------------------------------------------------------------------------}

end.
